/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.viewer;

import com.aptana.theme.ColorManager;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.util.UIUtils;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class CommonMergeViewer
extends TextMergeViewer {
    protected CommonMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
    }

    protected void configureTextViewer(final TextViewer textViewer) {
        ThemePlugin.getDefault().getControlThemerFactory().apply((ITextViewer)textViewer);
        UIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                CursorLinePainter p = CommonMergeViewer.this.getCursorLinePainterInstalled(textViewer);
                if (p != null) {
                    p.setHighlightColor(CommonMergeViewer.this.getColorManager().getColor(CommonMergeViewer.this.getCurrentTheme().getLineHighlightAgainstBG()));
                }
            }
        });
    }

    private CursorLinePainter getCursorLinePainterInstalled(TextViewer viewer) {
        Listener[] listeners;
        Listener[] listenerArray = listeners = viewer.getTextWidget().getListeners(3001);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            TypedListener typedListener;
            Listener listener = listenerArray[n2];
            if (listener instanceof TypedListener && (typedListener = (TypedListener)listener).getEventListener() instanceof CursorLinePainter) {
                return (CursorLinePainter)typedListener.getEventListener();
            }
            ++n2;
        }
        return null;
    }

    protected String getDocumentPartitioning() {
        return "__dftl_partitioning";
    }

    protected Theme getCurrentTheme() {
        return this.getThemeManager().getCurrentTheme();
    }

    protected IThemeManager getThemeManager() {
        return ThemePlugin.getDefault().getThemeManager();
    }

    protected ColorManager getColorManager() {
        return ThemePlugin.getDefault().getColorManager();
    }
}

